% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterReforms.R
\name{reform_data}
\alias{reform_data}
\title{Reform data}
\usage{
reform_data(data, p)
}
\arguments{
\item{data}{a matrix or class \code{'ts'} object with \code{d>1} columns. Each column is taken to represent
a univariate time series. Missing values are not supported.}

\item{p}{a positive integer specifying the autoregressive order}
}
\value{
Returns the data reformed into a \eqn{((n_{obs}-p+1)\times dp)} matrix. The i:th row
  of the matrix contains the vector \eqn{(y_{i-1},...,y_{i-p})} \eqn{(dp\times 1)}, where
  \eqn{y_{i}=(y_{1i},...,y_{di})} \eqn{(d \times 1)}.
}
\description{
\code{reform_data} reforms the data into a form that is
  easier to use when calculating log-likelihood values etc.
}
\details{
Assumes the observed data is \eqn{y_{-p+1},...,y_0,y_1,...,y_{T}}.
}
\section{Warning}{

 No argument checks!
}

\keyword{internal}
