% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correction_functions.R
\name{eem_raman_area}
\alias{eem_raman_area}
\title{Calculate raman area of EEM samples}
\usage{
eem_raman_area(eem_list, blanks_only = TRUE, average = FALSE)
}
\arguments{
\item{eem_list}{An object of class eemlist.}

\item{blanks_only}{logical. States whether all samples or just blanks will be used.}

\item{average}{logical. States whether samples will be averaged before calculating the raman area.}
}
\value{
data frame containing sample names, locations and raman areas
}
\description{
Calculate raman area of EEM samples
}
\details{
Code based on \code{\link[eemR]{eem_raman_normalisation}}.
}
\examples{
folder <- system.file("extdata/EEMs",package="staRdom")
eem_list <- eem_read(folder, recursive = TRUE, import_function = eem_csv)
blank <- eem_extract(eem_list,sample ="blank", keep = TRUE)

eem_raman_area(blank)
}
