% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_functions.R
\name{eem_name_replace}
\alias{eem_name_replace}
\title{Replace matched patterns in sample names}
\usage{
eem_name_replace(eem_list, pattern, replacement)
}
\arguments{
\item{eem_list}{data of class eemlist}

\item{pattern}{character vector containing pattern to look for.}

\item{replacement}{character vector of replacements. Has to have the same length as pattern}
}
\value{
An eemlist.
}
\description{
Sample names in eemlist can be altered.
}
\details{
\code{\link[stringr]{str_replace_all}} from package stringr is used for the replacement. Please read the corresponding help for further options.
}
\examples{
eem_names(eem_list)

eem_list <- eem_name_replace(eem_list,"sample","Sample")
eem_names(eem_list)
}
\seealso{
\code{\link[stringr]{str_replace_all}}
}
