% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{split_per_day}
\alias{split_per_day}
\title{Create a dataframe suitable for charts per 24h and day}
\usage{
split_per_day(data, horodatedebut, horodatefin)
}
\arguments{
\item{data}{The dataframe}

\item{horodatedebut}{The beginning time}

\item{horodatefin}{The ending time}
}
\value{
A data frame with four new columns, Hmin (hour min), Hmax (hmax), xmin (day) and xmax (next day),
and new rows
}
\description{
This functions takes a data frame with a column with starting time and another with ending time
If the period extends over midnight, it will be split into new lines, starting and ending at midnight
}
\examples{
datatemp<-structure(list(per_dis_identifiant = c(1L, 1L, 1L), 
per_date_debut = structure(c(1420056600, 
1420071000, 1420081200), class = c("POSIXct", "POSIXt"), tzone = ""), 
per_date_fin = structure(c(1420071000, 1420081200, 1421000000
), class = c("POSIXct", "POSIXt"), tzone = ""), per_commentaires = c("fonct calcul", 
"fonct calcul", "fonct calcul"), per_etat_fonctionnement = c(1L, 
0L, 0L), per_tar_code = 1:3, libelle = c("Fonc normal", "Arr ponctuel", 
"Arr maint")), .Names = c("per_dis_identifiant", "per_date_debut", 
"per_date_fin", "per_commentaires", "per_etat_fonctionnement", 
"per_tar_code", "libelle"), row.names = c(NA, 3L), class = "data.frame")
newdf<-split_per_day(data=datatemp,horodatedebut="per_date_debut",
horodatefin="per_date_fin")
}
\author{
cedric.briand
}

