% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_dc.R
\name{choice_c,ref_dc-method}
\alias{choice_c,ref_dc-method}
\title{Command line interface to select a counting device}
\usage{
\S4method{choice_c}{ref_dc}(object, dc)
}
\arguments{
\item{object}{an object of class ref_dc}

\item{dc}{a character vector of dc chosen}
}
\value{
An object of class ref_dc with dc selected
}
\description{
the choice_c method is intended to have the same behaviour as choice (which creates a
widget in the graphical interface) but from the command line.  The parameters for dc are transformed to integer as the ref_dc only
takes integer in the dc slots. The method also loads the stations and ouvrages (dams) associated with the counting device (dc).
The values passed to the choice_c method are then checked with the setValidty method.
Finally, if an objectreport is passed as a parameter, the method will do a charge_with_filter to select only the taxa present in the counting devices
}
\examples{
\dontrun{
win=gwindow()
group=ggroup(container=win,horizontal=FALSE)
object=new('ref_dc')
object<-charge(object)
objectreport=new('report_mig_mult')
choice_c(object=object,objectreport=objectreport,dc=1)
}
}
\author{
Cedric Briand \email{cedric.briand@eptb-vilaine.fr}
}
