\name{RequeteODBC-class}
\docType{class}
\alias{RequeteODBC-class}
\alias{RequeteODBC}
\title{Class "RequeteODBC"}
\description{ODBC Query. This class enables to retrieve data from the database. 
This class is inherited by RequeteODBCwhere and RequeteODBCwheredate
}
\note{
  Inherits from ConnectionODBC
}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("RequeteODBC", sql=character(), query=data.frame())}.
	 \describe{
    \item{\code{baseODBC}:}{Object of class \code{"vector"} The name, user and password of the database}
    \item{\code{connection}:}{Object of class \code{"ANY"} The connection}
    \item{\code{etat}:}{Object of class \code{"character"} The state of the query (Connecting, successful,...) }
    \item{\code{silent}:}{Object of class \code{"logical"} True if the query must be executed silently, FALSE}
    \item{\code{sql}:}{Object of class \code{"character"} The query}
    \item{\code{query}:}{Object of class \code{"data.frame"} The result of the query}
    \item{\code{open}:}{Object of class \code{"logical"} Should the connection remain open, choosing this ensures more rapid multiple queries}
	}
}

\section{Extends}{
Class \code{"\linkS4class{ConnectionODBC}"}, directly.
}
\section{Methods}{
  \describe{
    \item{connect}{\code{signature(object = "RequeteODBC")}: Connection to the database }
	 }
}

\author{cedric.briand"at"eptb-vilaine.fr}

\seealso{
	\code{\linkS4class{ConnectionODBC}}
	\code{\linkS4class{RequeteODBCwhere}}
	\code{\linkS4class{RequeteODBCwheredate}}
}
\examples{
showClass("RequeteODBC")
\dontrun{
 object=new("RequeteODBC")
 object@open=TRUE 
 ## this will leave the connection open, 
 ## by default it closes after the query is sent
 ## the following will work only if you have configured and ODBC link
 object@baseODBC=c("myODBCconnection","myusername","mypassword")
 object@sql= "select * from mytable limit 100"
 object<-connect(object)
 odbcClose(object@connection)
 envir_stacomi=new.env()
 ## While testing I like to see the output of sometimes complex queries generated by the program
 assign("showmerequest",1,envir_stacomi) 
 ## You can assign any values (here 1)
 ## just tests the existence of "showmerequest" in envir_stacomi
 object=new("RequeteODBC")
 object@baseODBC=c("myODBCconnection","myusername","mypassword")
 object@sql= "select * from mytable limit 100"
 object<-connect(object)
## the connection is already closed, the query is printed
}
}
\keyword{classes}