% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{ghoshdastidar}
\alias{ghoshdastidar}
\title{Ghoshdastidar hypothesis testing for large random graphs.}
\usage{
ghoshdastidar(x, y, maxPer = 300, alpha = 0.05, two.sample = FALSE,
  printResult = FALSE)
}
\arguments{
\item{x}{the first list of undirected graphs to be compared. Must be a list of matrices or igraph objects.}

\item{y}{the second list of undirected graphs to be compared. Must be a list of matrices or igraph objects.}

\item{maxPer}{integer indicating the number of bootstrap resamples (default is 300).}

\item{alpha}{the significance level for the test (default is 0.05).}

\item{two.sample}{logical. If TRUE the sets contain only one graph each. If FALSE the sets contain more than one graph each (default is FALSE).}

\item{printResult}{logical indicating if the test must print the result (default is FALSE).}
}
\value{
A list containing:
\item{test_stats}{the value of the test.}
\item{p_value}{the p-value of the test (only returned when the parameter 'two.sample' is FALSE).}
\item{bootstrap_samples}{The test distrition on the bootstrap resamples (only returned when the parameter 'two.sample' is FALSE).}
}
\description{
Given two lists of graphs generated by the inhomogeneous random graph model, 'ghoshdastidar' tests if they were generated by the same parameters.
}
\examples{
require(igraph)
set.seed(42)

## test for sets with more than one graph each under H0
x <- y <- list()
for(i in 1:10){
  x[[i]] <- as.matrix(get.adjacency(erdos.renyi.game(50,0.6)))
  y[[i]] <- as.matrix(get.adjacency(erdos.renyi.game(50,0.6)))
}
D <- ghoshdastidar(x, y, printResult = TRUE)

## test for sets with more than one graph each under H1
x <- y <- list()
for(i in 1:10){
  x[[i]] <- as.matrix(get.adjacency(erdos.renyi.game(50,0.6)))
  y[[i]] <- as.matrix(get.adjacency(erdos.renyi.game(50,0.7)))
}
D <- ghoshdastidar(x, y, printResult = TRUE)

## test for sets with only one graph each under H0
x <- y <- list()
x[[1]] <- erdos.renyi.game(300, 0.6)
y[[1]] <- erdos.renyi.game(300, 0.6)
D <- ghoshdastidar(x, y, two.sample= TRUE, printResult = TRUE)

## test for sets with only one graph each under H1
x <- y <- list()
x[[1]] <- erdos.renyi.game(300, 0.6)
y[[1]] <- erdos.renyi.game(300, 0.7)
D <- ghoshdastidar(x, y, two.sample= TRUE, printResult = TRUE)


}
\references{
Ghoshdastidar, Debarghya, et al. "Two-sample tests for large random graphs using network statistics". arXiv preprint arXiv:1705.06168 (2017).

Ghoshdastidar, Debarghya, et al. "Two-sample hypothesis testing for inhomogeneous random graphs". arXiv preprint, arXiv:1707.00833 (2017).
}
