% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{graph.cluster}
\alias{graph.cluster}
\title{Hierarchical cluster analysis on a list of graphs.}
\usage{
graph.cluster(x, k, method = "complete", bandwidth = "Silverman")
}
\arguments{
\item{x}{a list of adjacency (symmetric) matrices of undirected graphs. For
unweighted graphs, each matrix contains only 0s and 1s. For weighted graphs,
each matrix may contains real values that correspond to the weights of the
edges.}

\item{k}{the number of clusters.}

\item{method}{the agglomeration method to be used. This should be (an
unambiguous abbreviation of) one of ‘"ward.D"’, ‘"ward.D2"’, ‘"single"’,
‘"complete"’, ‘"average"’ (= UPGMA), ‘"mcquitty"’ (= WPGMA), ‘"median"’
(= WPGMC) or ‘"centroid"’ (= UPGMC).}

\item{bandwidth}{string indicating which criterion will be used to choose
the bandwidth for the spectral density estimation. The available criteria are
"Silverman" (default) and "Sturges".}
}
\value{
A list containing:
\item{hclust}{an object of class *hclust* which describes the tree produced
by the clustering process.}
\item{cluster}{the clustering labels for each graph.}
}
\description{
Given a list of graphs, 'graph.cluster' builds a hierarchy of clusters
according to the Jensen-Shannon divergence between graphs.
}
\examples{
require(igraph)
g <- list()
for (i in 1:5) {
    g[[i]] <- as.matrix(get.adjacency(
                        erdos.renyi.game(50, 0.5, type="gnp",
                                         directed = FALSE)))
}
for (i in 6:10) {
    g[[i]] <- as.matrix(get.adjacency(
                        watts.strogatz.game(1, 50, 8, 0.2)))
}
for (i in 11:15) {
    g[[i]] <- as.matrix(get.adjacency(
                        barabasi.game(50, power = 1,
                                      directed = FALSE)))
}
graph.cluster(g, 3)

}
\references{
Takahashi, D. Y., Sato, J. R., Ferreira, C. E. and Fujita A. (2012)
Discriminating Different Classes of Biological Networks by Analyzing the
Graph Spectra  Distribution. _PLoS ONE_, *7*, e49949.
doi:10.1371/journal.pone.0049949.

Silverman, B. W. (1986) _Density Estimation_.  London: Chapman and Hall.

Sturges, H. A. The Choice of a Class Interval. _J. Am. Statist. Assoc._,
*21*, 65-66.
}
\keyword{clustering}
