% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{cerqueira.test}
\alias{cerqueira.test}
\title{Andressa Cerqueira, Daniel Fraiman, Claudia D. Vargas and Florencia Leonardi
non-parametric test of hypotheses to verify if two samples of random graphs
were originated from the same probability distribution.}
\usage{
cerqueira.test(G1, G2, maxBoot = 300)
}
\arguments{
\item{G1}{the first iid sample of graphs to be compared. Must be a list of
igraph objects.}

\item{G2}{the second iid sample of graphs to be compared. Must be a list of
igraph objects.}

\item{maxBoot}{integer indicating the number of bootstrap resamples (default
is 300).}
}
\value{
A list containing:
\item{W}{the value of the test.}
\item{p.value}{the p-value of the test.}
}
\description{
Given two identically independently distributed (idd) samples of graphs G1 and
G2, the test verifies if they have the same distribution by calculating the
mean distance D from G1 to G2. The test rejects the null hypothesis if D is
greater than the (1-alpha)-quantile of the distribution of the test under the
null hypothesis.
}
\examples{
\dontrun{
set.seed(42)

## test under H0
G1 <- G2 <- list()
for(i in 1:10){
  G1[[i]] <- igraph::sample_gnp(50,0.5)
  G2[[i]] <- igraph::sample_gnp(50,0.5)
}
k1 <- cerqueira.test(G1, G2)
k1

## test under H1
G1 <- G2 <- list()
for(i in 1:10){
  G1[[i]] <- igraph::sample_gnp(50,0.5)
  G2[[i]] <- igraph::sample_gnp(50,0.6)
}
k2 <- cerqueira.test(G1, G2)
k2
}

}
\references{
Andressa Cerqueira, Daniel Fraiman, Claudia D. Vargas and Florencia Leonardi.
"A test of hypotheses for random graph distributions built from EEG data",
https://ieeexplore.ieee.org/document/7862892
}
