% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statCanR.R
\name{statcanR-deprecated}
\alias{statcanR-deprecated}
\alias{sqs_statcan_data}
\title{deprecated-statcanR}
\usage{
sqs_statcan_data(tableNumber, lang)
}
\arguments{
\item{tableNumber}{The table number of the Statistics Canada data table}

\item{lang}{The language wanted}
}
\value{
The output will be a data table representing the data associated with the chosen table number.
}
\description{
Easily connect to Statistics Canada's Web Data Service with R. Open economic data (formerly known as CANSIM tables, now identified by Product IDs (PID)) are accessible as a data frame, directly in the user's R environment.
}
\details{
The
\code{sqs_statcan_data()} function has 2 arguments to fulfill to get data: {tableNumber} & {lang}.


The tableNumber argument simply refers to the table number of the Statistics Canada data table a user wants to collect,
such as '27-10-0014-01' for the Federal expenditures on science and technology, by socio-economic objectives, as an example.


To get the table number: \url{https://www150.statcan.gc.ca/n1/en/type/data}.

The second argument, lang, refers to the language. As Canada is a bilingual country, Statistics Canada displays all the economic data in both languages.
Therefore, users can choose to collect satistics data tables in French or English by setting the lang argument with c('fra', 'eng').
}
\examples{
mydata <- sqs_statcan_data('27-10-0014-01', 'eng')




}
