% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{country_names}
\alias{country_names}
\title{Country names}
\usage{
country_names(x, list = "GW", shorten = FALSE)
}
\arguments{
\item{x}{(\code{\link[=numeric]{numeric()}})\cr
A vector of numeric country codes}

\item{list}{(\code{logical(1)})\cr
Which states list to use? Only "GW" at this time.}

\item{shorten}{(\code{logical(1)})\cr
Shorten some of the longer country names like "Macedonia, the former Yugoslav Republic of"?}
}
\description{
Country names
}
\examples{
data("gwstates")
codes <- gwstates$gwcode
cn    <- country_names(codes)
cs    <- country_names(codes, shorten = TRUE)
data.frame(gwcode = codes, country_name = cn, short_names = cs)

}
