% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cholesky.R
\name{Cholesky}
\alias{Cholesky}
\title{Construct a Valid Variance - Covariance Matrix}
\usage{
Cholesky(param = NULL, format = NULL, decompositions = TRUE)
}
\arguments{
\item{param}{Vector containing the parameters used to construct the
variance - covariance matrix.}

\item{format}{Matrix representing the format for the Loading matrix L
and Diagonal matrix D. The lower triangular part of the format is used
as the format for the Loading matrix L. The diagonal of the format is
used as the format for the Diagonal matrix D. Must be a matrix.}

\item{decompositions}{Boolean indicating whether the loading and diagonal
matrix of the Cholesky decomposition, and the correlation matrix and
standard deviations should be returned.}
}
\value{
A valid variance - covariance matrix.
If \code{decompositions = TRUE} then it returns a list containing:
\itemize{
\item \code{cov_mat}: The variance - covariance matrix.
\item \code{loading_matrix}: The loading matrix of the Cholesky decomposition.
\item \code{diagonal_matrix}: The diagonal matrix of the Cholesky decomposition.
\item \code{correlation_matrix}: Matrix containing the correlations.
\item \code{stdev_matrix}: Matrix containing the standard deviations on the diagonal.
}
}
\description{
Constructs a valid variance - covariance matrix by using the Cholesky LDL
decomposition.
}
\details{
\code{format} is used to specify which elements of the loading and diagonal
matrix should be non-zero. The elements of \code{param} are then distributed
along the non-zero elements of the loading and diagonal matrix.
The parameters for the diagonal matrix are transformed using \code{exp(2 * x)}.
}
\examples{
format <- diag(1, 2, 2)
format[2, 1] <- 1
Cholesky(param = c(2,4,1), format = format, decompositions = TRUE)

}
\author{
Dylan Beijers, \email{dylanbeijers@gmail.com}
}
