% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimSmoother.R
\name{SimSmoother}
\alias{SimSmoother}
\title{Generating Random Samples using the Simulation Smoother}
\usage{
SimSmoother(object, nsim = 1, components = TRUE)
}
\arguments{
\item{object}{A statespacer object as returned by \code{\link{statespacer}}.}

\item{nsim}{Number of random samples to draw. Defaults to \code{1}.}

\item{components}{Boolean indicating whether the components of
the model should be extracted in each of the random samples.}
}
\value{
A list containing the simulated state parameters and disturbances.
In addition, it returns the components as specified by the State Space model
if \code{components = TRUE}. Each of the objects are arrays, where the first
dimension equals the number of time points, the second dimension the number
of state parameters, disturbances, or dependent variables, and the third
dimension equals the number of random samples \code{nsim}.
}
\description{
Draws random samples of the specified model conditional
on the observed data.
}
\examples{
# Fits a local level model for the Nile data
library(datasets)
y <- matrix(Nile)
fit <- statespacer(initial = 10, y = y, local_level_ind = TRUE)

# Obtain random sample using the fitted model
sim <- SimSmoother(fit, nsim = 1, components = TRUE)

# Plot the simulated level against the smoothed level of the original data
plot(sim$level[, 1, 1], type = 'p')
lines(fit$smoothed$level, type = 'l')
}
\author{
Dylan Beijers, \email{dylanbeijers@gmail.com}
}
