% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateSplineParameters.R
\name{plot.HTPSplineEst}
\alias{plot.HTPSplineEst}
\title{Plot the results of estimated spline parameters.}
\usage{
\method{plot}{HTPSplineEst}(
  x,
  ...,
  plotType = c("box", "hist"),
  what = attr(x, "what"),
  title = NULL,
  output = TRUE,
  outFile = NULL,
  outFileOpts = NULL
)
}
\arguments{
\item{x}{An object of class \code{HTPSpline}.}

\item{...}{Ignored.}

\item{plotType}{A character string indicating the type of plot to be made.}

\item{what}{The types of estimate that should be extracted.}

\item{title}{A character string used as title for the plot. If \code{NULL} a
default title is added to the plot depending on \code{plotType}.}

\item{output}{Should the plot be output to the current device? If
\code{FALSE} only a (list of) ggplot object(s) is invisibly returned. Ignored if
\code{outFile} is specified.}

\item{outFile}{A character string indicating the .pdf file to which the
plots should be written. If \code{NULL}, no file is written.}

\item{outFileOpts}{A named list of extra options for the pdf outfile, e.g.
width and height. See \code{\link[grDevices]{pdf}} for all possible options.}
}
\value{
A list of object of class ggplot is invisibly returned.
}
\description{
Plot the results of estimated spline parameters.
}
\seealso{
Other functions for spline parameter estimation: 
\code{\link{estimateSplineParameters}()}
}
\concept{functions for spline parameter estimation}
