% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readRabbit.R
\name{readRABBIT}
\alias{readRABBIT}
\title{Read IBD probabilities}
\usage{
readRABBIT(infile, pedFile = NULL, pheno = NULL)
}
\arguments{
\item{infile}{A character string, a link to a .csv file with IBD
probabilities.}

\item{pedFile}{A character string, a link to a .csv file with pedigree
information as used by RABBIT as input.}

\item{pheno}{A data frame with at least columns "genotype" for the
"genotype" and one or more numerical columns containing phenotypic
information. if \code{pedFile} is not specified also a column "cross"
indicating the cross the genotype comes from is required.}
}
\value{
A \code{gDataMPP} object with map and markers corresponding to the
imported information in the imported .csv file.
}
\description{
Read a file with IBD probabilities computed by the RABBIT software package.
It is possible to additionally read the pedigree file that is also used by
RABBIT. Reading this file allows for plotting the pedigree. Phenotypic data
can be added from a data.frame.
}
\examples{
## Read RABBIT data for barley.
genoFile <- system.file("extdata/barley", "barley_magicReconstruct.zip",
                       package = "statgenMPP")
barleyMPMPP <- readRABBIT(unzip(genoFile, exdir = tempdir()))

}
\references{
Reference to RABBIT.....
}
