% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.agree2}
\alias{ci.agree2}
\title{Confidence interval for G-index difference in a 2-group design}
\usage{
ci.agree2(alpha, n1, f1, n2, f2, r)
}
\arguments{
\item{alpha}{alpha level for simultaneous 1-alpha confidence}

\item{n1}{sample size (objects) in group 1}

\item{f1}{number of objects rated in agreement in group 1}

\item{n2}{sample size (objects) in group 2}

\item{f2}{number of objects rated in agreement in group 2}

\item{r}{number of rating categories}
}
\value{
Returns a 3-row matrix. The rows are:
\itemize{
\item Row 1: G-index for group 1
\item Row 2: G-index for group 2
\item Row 3: G-index difference
}

The columns are:
\itemize{
\item Estimate - estimate of G-index (single-group and difference)
\item LL - lower limit of confidence interval
\item UL - upper limit of confidence interval
}
}
\description{
Computes adjusted Wald confidence intervals for the G-index of agreement
within each group and the difference of G-indices. The point estimates are
maximum likelihood estimates.
}
\examples{
ci.agree2(.05, 75, 70, 60, 45, 2)

# Should return:
#          Estimate        LL        UL
# G1      0.8666667 0.6974555 0.9481141
# G2      0.5000000 0.2523379 0.6851621
# G1 - G2 0.3666667 0.1117076 0.6088621


}
