% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.cronbach}
\alias{ci.cronbach}
\title{Confidence interval for a Cronbach reliability}
\usage{
ci.cronbach(alpha, rel, r, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{rel}{estimated Cronbach's reliability}

\item{r}{number of measurements (items, raters, etc.)}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a population Cronbach reliability.
The point estimate of Cronbach's reliability assumes essentially
tau-equivalent measurements and this confidence interval assumes parallel
measurements.
}
\examples{
ci.cronbach(.05, .85, 7, 89)

# Should return:
# Estimate          SE        LL        UL
#     0.85  0.02456518 0.7971254 0.8931436   
 

}
\references{
\insertRef{Feldt1965}{statpsych}
}
