% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.median.ps}
\alias{ci.median.ps}
\title{Confidence interval for a paired-samples median difference}
\usage{
ci.median.ps(alpha, y1, y2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y1}{vector of scores for measurement 1}

\item{y2}{vector of scores for measurement 2 (paired with y1)}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Median1 - estimated median for measurement 1
\item Median2 - estimated median for measurement 2
\item Median1-Median2 - estimated difference of medians
\item SE1 - standard error of median 1
\item SE2 - standard error of median 2
\item COV - covariance of the two estimated medians
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a difference of population medians in
a paired-samples design. This function also computes the standard errors
for each median and the covariance between the two estimated medians.
}
\examples{
y1 <- c(21, 4, 9, 12, 35, 18, 10, 22, 24, 1, 6, 8, 13, 16, 19)
y2 <- c(67, 28, 30, 28, 52, 40, 25, 37, 44, 10, 14, 20, 28, 40, 51)
ci.median.ps(.05, y1, y2)

# Should return:
# Median1 Median2 Median1-Median2       SE        LL        UL  
#      13      30             -17 3.362289 -23.58996 -10.41004 
#      SE1      SE2      COV
# 3.085608 4.509735 9.276849


}
\references{
\insertRef{Bonett2020}{statpsych}
}
