% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.R
\name{computeForestLeafIndices}
\alias{computeForestLeafIndices}
\title{Compute vector of forest leaf indices}
\usage{
computeForestLeafIndices(
  model_object,
  covariates,
  forest_type = NULL,
  forest_inds = NULL
)
}
\arguments{
\item{model_object}{Object of type \code{bartmodel}, \code{bcfmodel}, or \code{ForestSamples} corresponding to a BART / BCF model with at least one forest sample, or a low-level \code{ForestSamples} object.}

\item{covariates}{Covariates to use for prediction. Must have the same dimensions / column types as the data used to train a forest.}

\item{forest_type}{Which forest to use from \code{model_object}.
Valid inputs depend on the model type, and whether or not a given forest was sampled in that model.

\strong{1. BART}
\itemize{
\item \code{'mean'}: Extracts leaf indices for the mean forest
\item \code{'variance'}: Extracts leaf indices for the variance forest
}

\strong{2. BCF}
\itemize{
\item \code{'prognostic'}: Extracts leaf indices for the prognostic forest
\item \code{'treatment'}: Extracts leaf indices for the treatment effect forest
\item \code{'variance'}: Extracts leaf indices for the variance forest
}

\strong{3. ForestSamples}
\itemize{
\item \code{NULL}: It is not necessary to disambiguate when this function is called directly on a \code{ForestSamples} object. This is the default value of this
}}

\item{forest_inds}{(Optional) Indices of the forest sample(s) for which to compute leaf indices. If not provided,
this function will return leaf indices for every sample of a forest.
This function uses 0-indexing, so the first forest sample corresponds to \code{forest_num = 0}, and so on.}
}
\value{
List of vectors. Each vector is of size \code{num_obs * num_trees}, where \code{num_obs = nrow(covariates)}
and \code{num_trees} is the number of trees in the relevant forest of \code{model_object}.
}
\description{
Compute and return a vector representation of a forest's leaf predictions for
every observation in a dataset.

The vector has a "row-major" format that can be easily re-represented as
as a CSR sparse matrix: elements are organized so that the first \code{n} elements
correspond to leaf predictions for all \code{n} observations in a dataset for the
first tree in an ensemble, the next \code{n} elements correspond to predictions for
the second tree and so on. The "data" for each element corresponds to a uniquely
mapped column index that corresponds to a single leaf of a single tree (i.e.
if tree 1 has 3 leaves, its column indices range from 0 to 2, and then tree 2's
leaf indices begin at 3, etc...).
}
\examples{
X <- matrix(runif(10*100), ncol = 10)
y <- -5 + 10*(X[,1] > 0.5) + rnorm(100)
bart_model <- bart(X, y, num_gfr=0, num_mcmc=10)
computeForestLeafIndices(bart_model, X, "mean")
computeForestLeafIndices(bart_model, X, "mean", 0)
computeForestLeafIndices(bart_model, X, "mean", c(1,3,9))
}
