% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{svlsample2}
\alias{svlsample2}
\title{Minimal overhead version of \code{\link{svlsample}}.}
\usage{
svlsample2(y, draws = 1, burnin = 0, priormu = c(0, 100),
  priorphi = c(5, 1.5), priorsigma = 1, priorrho = c(4, 4),
  thinpara = 1, thinlatent = 1, thintime = NULL, keeptime = "all",
  quiet = TRUE, startpara, startlatent)
}
\arguments{
\item{y}{numeric vector containing the data (usually log-returns), which
must not contain zeros. Alternatively, \code{y} can be an \code{svsim}
object. In this case, the returns will be extracted and a warning is thrown.}

\item{draws}{single number greater or equal to 1, indicating the number of
draws after burn-in (see below). Will be automatically coerced to integer.
The default value is 1.}

\item{burnin}{single number greater or equal to 0, indicating the number of
draws discarded as burn-in. Will be automatically coerced to integer. The
default value is 0.}

\item{priormu}{numeric vector of length 2, indicating mean and standard
deviation for the Gaussian prior distribution of the parameter \code{mu},
the level of the log-volatility. The default value is \code{c(0, 100)},
which constitutes a practically uninformative prior for common exchange rate
datasets, stock returns and the like.}

\item{priorphi}{numeric vector of length 2, indicating the shape parameters
for the Beta prior distribution of the transformed parameter
\code{(phi + 1) / 2}, where \code{phi} denotes the persistence of the
log-volatility. The default value is \code{c(5, 1.5)}, which constitutes a
prior that puts some belief in a persistent log-volatility but also
encompasses the region where \code{phi} is around 0.}

\item{priorsigma}{single positive real number, which stands for the scaling
of the transformed parameter \code{sigma^2}, where \code{sigma} denotes the
volatility of log-volatility. More precisely, \code{sigma^2 ~ priorsigma *
chisq(df = 1)}. The default value is \code{1}, which constitutes a
reasonably vague prior for many common exchange rate datasets, stock returns
and the like.}

\item{priorrho}{numeric vector of length 2, indicating the shape parameters
for the Beta prior distribution of the transformed parameter
\code{(rho + 1) / 2}, where \code{rho} denotes the conditional correlation
between observation and the increment of the
log-volatility. The default value is \code{c(4, 4)}, which constitutes a
slightly informative prior around 0 (the no leverage case) to boost convergence.}

\item{thinpara}{single number greater or equal to 1, coercible to integer.
Every \code{thinpara}th parameter draw is kept and returned. The default
value is 1, corresponding to no thinning of the parameter draws i.e. every
draw is stored.}

\item{thinlatent}{single number greater or equal to 1, coercible to integer.
Every \code{thinlatent}th latent variable draw is kept and returned. The
default value is 1, corresponding to no thinning of the latent variable
draws, i.e. every draw is kept.}

\item{thintime}{\emph{Deprecated.} Use 'keeptime' instead.}

\item{keeptime}{Either 'all' (the default) or 'last'. Indicates which latent}

\item{quiet}{logical value indicating whether the progress bar and other
informative output during sampling should be omitted. The default value is
\code{TRUE}.}

\item{startpara}{\emph{compulsory} named list, containing the starting values
for the parameter draws. It must contain four
elements named \code{mu}, \code{phi}, \code{sigma}, and \code{rho}, where \code{mu} is
an arbitrary numerical value, \code{phi} is a real number between \code{-1}
and \code{1}, \code{sigma} is a positive real number, and \code{rho} is
a real number between \code{-1} and \code{1}.}

\item{startlatent}{\emph{compulsory} vector of length \code{length(y)},
containing the starting values for the latent log-volatility draws.}
}
\value{
The value returned is a list object holding
\item{para}{matrix of dimension \code{4 x draws} containing
the \emph{parameter} draws from the posterior distribution.}
\item{latent}{matrix of dimension \code{length(y) x draws} containing the
\emph{latent instantaneous log-volatility} draws from the posterior
distribution.}
\item{meanmodel}{always equals \code{"none"}}
}
\description{
\code{svlsample2} is a minimal overhead version of \code{\link{svlsample}}
with slightly different default arguments and a simplified return value
structure. It is intended to be used mainly for one-step updates where speed
is an issue, e.g., as a plug-in into other MCMC samplers. Note that
absolutely no input checking is performed, thus this function is to be used
with proper care!
}
\details{
As opposed to the ordinary \code{\link{svlsample}}, the default values differ
for \code{draws}, \code{burnin}, and \code{quiet}. Note that currently
neither \code{expert} nor \code{\dots{}} arguments are provided.
}
\examples{
data(exrates)
aud.price <- subset(exrates,
  as.Date("2010-01-01") <= date & date < as.Date("2011-01-01"),
  "AUD")[,1]
draws <- svlsample2(logret(aud.price),
                    draws = 10, burnin = 0,
                    startpara = list(phi=0.95, mu=-10, sigma=0.2, rho=-0.1),
                    startlatent = rep_len(-10, length(aud.price)-1))
}
\seealso{
\code{\link{svlsample}}
}
\author{
Darjus Hosszejni \email{darjus.hosszejni@wu.ac.at}
}
\keyword{models}
\keyword{ts}
