% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/my_wind_code.R
\name{add_wind_radii}
\alias{add_wind_radii}
\title{Add Willoughby inputs and parameters}
\usage{
add_wind_radii(full_track = create_full_track())
}
\arguments{
\item{full_track}{A dataframe with interpolated hurricane track data, as
created by \code{\link{create_full_track}}. This dataframe must have the
following columns:
\itemize{
  \item{\code{date:} Date-time, in POSIXct format and UTC time zone}
  \item{\code{tclat:} Latitude (decimal degree)}
  \item{\code{tclon:} Longitude (decimal degrees), expressed as positive
        values (this model assumes all longitudes will be in the
        Western hemisphere)}
  \item{\code{vmax:} Maximum 10-meter sustained wind speed (m / s)}
}}
}
\value{
The input dataset, but with columns added for the Willoughby
   parameters for every observations. Added columns include:
   \itemize{
     \item{\code{tcdir:} The bearing of the storm, in degrees, with 0 degrees
       indicating the storm is moving due east, 90 degrees indicating the
       storm is moving due north, etc.}
     \item{\code{tcspd_u, tcspd_v:} The u- and v-components of the forward
     speed of the storm, in meters per second}
     \item{\code{vmax_gl:} The maximum gradient-level 1-minute sustained
       wind, in m / s}
     \item{\code{Rmax:} The radius to maximum winds, in kilometers}
     \item{\code{X1, n, A, R1, R2:} Parameters needed for
       the Willoughby wind model}
   }
}
\description{
Calculates a number of inputs and parameters needed for the Willoughby model
for each observation of a storm track. This function intakes an inputed storm
track and calculates these parameters for each observation in the storm
tracks.These inputs and parameters are later used to model wind speed
at each grid point for every observation.
}
\examples{
\dontrun{
data("floyd_tracks")
full_track <- create_full_track(hurr_track = floyd_tracks)
with_wind_radii <- add_wind_radii(full_track = full_track)
head(with_wind_radii)
}

}
\references{
Willoughby HE, Darling RWR, and Rahn ME. 2006. Parametric representation
of the primary hurricane vortex. Part II: A new family of sectionally
continuous profiles. Monthly Weather Review 134(4):1102-1120.
}
