% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_case.R
\name{get_case}
\alias{get_case}
\title{Retreive a parliamentary case}
\usage{
get_case(caseid = NA, good_manners = 0)
}
\arguments{
\item{caseid}{Character string indicating the id of the case to request}

\item{good_manners}{Integer. Seconds delay between calls when making multiple calls to the same function}
}
\value{
A list with seven data frame elements:
\enumerate{
\item \strong{$root} (main data on the case)\tabular{ll}{
    \tab  \cr
   \strong{response_date} \tab Date of data retrieval \cr
   \strong{version} \tab Data version from the API \cr
   \strong{document_group} \tab Case document group type \cr
   \strong{finalized} \tab Whether the case finalized \cr
   \strong{reference} \tab Relevant publication references \cr
   \strong{id} \tab Case id \cr
   \strong{req_text} \tab Recommendation (proposal) text \cr
   \strong{committee_id} \tab Id of committee handling the case \cr
   \strong{title_short} \tab Case short title \cr
   \strong{decision_short} \tab Case decision_short \cr
   \strong{parenthesis_text} \tab Case parenthesis text \cr
   \strong{case_number} \tab Case number \cr
   \strong{session_id} \tab Session id \cr
   \strong{proceedings_id} \tab Type of proceeding id \cr
   \strong{proceedings_name} \tab Type of proceeding name \cr
   \strong{status} \tab Status for case \cr
   \strong{title} \tab Case title (long) \cr
   \strong{type} \tab Case type \cr
   \strong{decision_text} \tab Decision text \cr
}

\item \strong{$topic} (the topics related to the case)\tabular{ll}{
    \tab  \cr
   \strong{is_main_topic} \tab Is this (row) the main topic? \cr
   \strong{main_topic_id} \tab Id for main topic \cr
   \strong{id} \tab Topic id \cr
   \strong{navn} \tab Topic name \cr
}

\item \strong{$publication_references} (references for publications on the case)\tabular{ll}{
    \tab  \cr
   \strong{export_id} \tab Id for export of publication (used in ?get_publication) \cr
   \strong{link_text} \tab Publication title \cr
   \strong{link_url} \tab URL to publication \cr
   \strong{type} \tab Publication type \cr
   \strong{subtype} \tab Publication subtype (chamber) \cr
}

\item \strong{$proposers} (MPs behind case proposal, when relevant)\tabular{ll}{
    \tab  \cr
   \strong{mp_id} \tab MPs id \cr
   \strong{party_id} \tab Party id of MPs \cr
   \strong{sub_mp} \tab Whether MPs are substitutes \cr
}

\item \strong{$proceeding_steps} (case proceeding steps)\tabular{ll}{
    \tab  \cr
   \strong{step_name} \tab Name of steps \cr
   \strong{step_number} \tab Step order for case \cr
   \strong{outdated} \tab Whether the step type is outdated \cr
}

\item \strong{$spokespersons} (all MPs that are spokespersons for the case)\tabular{ll}{
    \tab  \cr
   \strong{mp_id} \tab MPs id \cr
   \strong{party_id} \tab Party id of MPs \cr
   \strong{sub_mp} \tab Whether MPs are substitutes \cr
}

\item \strong{$keywords} (all keywords associated with the case)\tabular{ll}{
    \tab  \cr
   \strong{keyword} \tab Keywords for the case \cr
}

}
}
\description{
A function for retrieving single parliamentary case by id.
}
\examples{

\dontrun{

# Get one case
case <- get_case("30233")
case

# Get multiple cases
cases <- lapply(c("30233", "30362", "30234", "30236"), get_case, good_manners = 2)
cases_root <- lapply(cases, function(x) x$root)
cases_root <- do.call(rbind, cases_root)
cases_root

cases_keywords <- lapply(1:nrow(cases_root), function(x){
  tmp <- cases[[x]]$keywords
  tmp$case_id <- cases_root$id[x]
  return(tmp)
})
cases_keywords <- do.call(rbind, cases_keywords)
cases_keywords

}
}
\seealso{
\link{get_session_cases}
}
