% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{od_dist}
\alias{od_dist}
\title{Quickly calculate Euclidean distances of od pairs}
\usage{
od_dist(flow, zones)
}
\arguments{
\item{flow}{A data frame representing the flow between two points
or zones. The first two columns of this data frame should correspond
to the first column of the data in the zones. Thus in \code{\link[=cents]{cents()}},
the first column is geo_code. This corresponds to the first two columns
of \code{\link[=flow]{flow()}}.}

\item{zones}{A spatial object representing origins (and destinations
if no separate destinations object is provided) of travel.}
}
\description{
It is common to want to know the Euclidean distance between origins and destinations
in OD data. You can calculate this by first converting OD data to SpatialLines data,
e.g. with \code{\link[=od2line]{od2line()}}. However this can be slow and overkill if you just
want to know the distance. This function is a few orders of magnitude faster.
}
\details{
Note: this function assumes that the zones or centroids in \code{cents} have a geographic
(lat/lon) CRS.
}
\examples{
data(flow)
data(cents)
od_dist(flow, cents)
}
\seealso{
Other od: \code{\link{dist_google}}, \code{\link{od2line}},
  \code{\link{od2odf}}, \code{\link{od_aggregate_from}},
  \code{\link{od_aggregate_to}},
  \code{\link{od_aggregate}}, \code{\link{od_coords2line}},
  \code{\link{od_coords}}, \code{\link{od_id}},
  \code{\link{od_oneway}}, \code{\link{od_radiation}},
  \code{\link{od_to_odmatrix}},
  \code{\link{odmatrix_to_od}}, \code{\link{points2flow}},
  \code{\link{points2odf}}, \code{\link{sp_aggregate}}
}
\concept{od}
