% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneway.R
\name{od_id}
\alias{od_id}
\alias{od_id_szudzik}
\alias{od_id_max_min}
\alias{od_id_character}
\title{Combine two ID values to create a single ID number}
\usage{
od_id_szudzik(x, y, ordermatters = FALSE)

od_id_max_min(x, y)

od_id_character(x, y)
}
\arguments{
\item{x}{a vector of numeric, character, or factor values}

\item{y}{a vector of numeric, character, or factor values}

\item{ordermatters}{logical, does the order of values matter to pairing, default = FALSE}
}
\description{
Combine two ID values to create a single ID number
}
\details{
In OD data it is common to have many 'oneway' flows from "A to B" and "B to A".
It can be useful to group these an have a single ID that represents pairs of IDs
with or without directionality, so they contain 'twoway' or bi-directional values.

\verb{od_id*} functions take two vectors of equal length and return a vector of IDs,
which are unique for each combination but the same for twoway flows.
\itemize{
\item the Szudzik pairing function, on two vectors of equal
length. It returns a vector of ID numbers.
}

This function superseeds od_id_order as it is faster on large datasets
}
\examples{
(d <- od_data_sample[2:9, 1:2])
(id <- od_id_character(d[[1]], d[[2]]))
duplicated(id)
od_id_szudzik(d[[1]], d[[2]])
od_id_max_min(d[[1]], d[[2]])
}
\seealso{
od_oneway

Other od: 
\code{\link{od2line}()},
\code{\link{od2odf}()},
\code{\link{od_aggregate_from}()},
\code{\link{od_aggregate_to}()},
\code{\link{od_coords2line}()},
\code{\link{od_coords}()},
\code{\link{od_oneway}()},
\code{\link{od_to_odmatrix}()},
\code{\link{odmatrix_to_od}()},
\code{\link{points2flow}()},
\code{\link{points2odf}()}
}
\concept{od}
