% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{a2d}
\alias{a2d}
\title{(3D+) Array to Data-Frame}
\usage{
a2d(a, col = 0, stringsAsFactors = FALSE, check = TRUE)
}
\arguments{
\item{a}{3D+ array.}

\item{col}{integer vector or character vector of length 1 specifing the dimension
of \code{a} to have as columns in the return object. If an integer vector,
\code{col} refers to the dimension number. If a character vector, \code{col}
refers to the name of the dimension. The columns are in order of the dimnames
for that dimension (not alphabetical order like \code{reshape::cast}). If 0
(default), then no dimension of the array has a column and the function becomes
similar to \code{as.data.frame.table}.}

\item{stringsAsFactors}{logical vector of length 1 specifying whether the variable
dimensions should be factors of chracter vectors.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{a} is a (3D+) array.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
data.frame of \code{a}'s elements. The colnames of the variable dimensions
are the names of the dimensions in \code{a}. If there were no dimension names in
\code{a}, then each dimension is named after its number with an X in front.
If \code{col} is not 0, then the rest of the colnames are the dimnames of
that dimension from \code{a}. If \code{col} is 0, then the names of the single
column with \code{a}'s elements is "element".
}
\description{
\code{a2d} converts a (3D+ array) to a data.frame. It allows you to specify a
dimension of the array to be the columns. All other dimensions are variables
in the data.frame. This is different than \code{as.data.frame.array} which
converts the (3D+) array to a matrix first; although it is very similar to
\code{as.data.frame.table}.
}
\details{
\code{a2d} is mostly a wrapper for \code{reshape::melt.array} (+ \code{reshape::cast})
that allows for the variable dimensions to be character vectors rather than factors.
}
\examples{
a2d(HairEyeColor)
a2d(HairEyeColor, col = 1)
a2d(HairEyeColor, col = "Hair", stringsAsFactors = TRUE)
a2d(HairEyeColor, col = 2)
a2d(HairEyeColor, col = "Sex", stringsAsFactors = TRUE)
try_expr(a2d(as.matrix(attitude))) # error due to inputting a matrix. Instead use \code{m2d}.
}
