% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{order.custom}
\alias{order.custom}
\title{Custom Order Permutation}
\usage{
order.custom(X, ORD, na.last = FALSE, decreasing = FALSE)
}
\arguments{
\item{X}{list of atomic vectors parellel matched with the atomic vectors in \code{X}
specifying the elements to be ordered. Can also be a single atomic vector, which
will internally be converted to a list with one element.}

\item{ORD}{list of atomic vectors that do NOT have to be the same length
specifying the order of the unique values for sorting. Can also be a single
atomic vector, which will internally be converted to a list with one element.}

\item{na.last}{logical vector of length 1 specifying whether missing values
should be put last (TRUE), first (FALSE), or removed (NA).}

\item{decreasing}{logical vector of length 1 specifying whether the sorting
should start with the first element of the atomic vectors within \code{ORD}
and proceed forward (FALSE) or the last element of the atomic vectors within
\code{ORD} and proceed backwards (TRUE).}
}
\value{
integer vector of length = \code{X[[1]]} (after converting \code{X} to
a list with one element is need be) providing the revised order of the atomic
vectors within \code{X} that sorts them according to \code{ORD}.
}
\description{
\code{order.custom} creates the order of the positions in the atomic vectors
from \code{X} that would cause the atomic vectors from \code{X} to be sorted
according to the atomic vectors from \code{ORD}. This is analogus to the
\code{order} function, but instead of doing default sorting (e.g., 1, 2, 3, etc.
or "A", "B", "C", etc.), the sorting is customized by \code{ORD}.
\code{order.custom} does custom ordering by converting each atomic vector from
\code{X} to an ordered factor and then default sorting the ordered factors.
}
\details{
Note, that the atomic vectors within \code{X} are always forward sequenced;
if backward sequence is desired, then the user should call \code{rev} on both
the input to \code{X} and \code{ORD}. This is analogous to reversing the
order of the atomic vectors given to \code{...} within \code{order}.
}
\examples{
# character vector
x <- esoph[["tobgp"]]
order.custom(X = x, ORD = c("20-29","10-19","30+","0-9g/day"))
x[order.custom(X = x, ORD = c("20-29","10-19","30+","0-9g/day"))] # returns character
esoph[order.custom(X = x, ORD = c("20-29","10-19","30+","0-9g/day")), ]
# order by position
sort(state.region)
x <- as.character(state.region)
order.custom(X = x, ORD = unique(x))
x[order.custom(X = x, ORD = unique(x))]
# numeric vector
y <- esoph[["ncases"]]
order.custom(X = y, ORD = c(6,5,4,3,2,1,0,17,8,9))
y[order.custom(X = y, ORD = c(6,5,4,3,2,1,0,17,8,9))] # returns numeric
esoph[order.custom(X = y, ORD = c(6,5,4,3,2,1,0,17,8,9)), ]
   # some unique values not provided in `ORD` (appended at the end and sorted by
   # where they appear in the dataset)
y <- esoph[["ncases"]]
order.custom(X = y, ORD = c(6,5,4,3,2,1,0))
y[order.custom(X = y, ORD = c(6,5,4,3,2,1,0))] # returns numeric
esoph[order.custom(X = y, ORD = c(6,5,4,3,2,1,0)), ]
# multiple vectors
z <- esoph[c("agegp","alcgp","tobgp")]
ord <- order.custom(X = z, ORD = list(
   "agegp" = c("45-54","55-64","35-44","65-74","25-34","75+"),
   "alcgp" = c("40-79","80-119","0-39g/day","120+"),
   "tobgp" = c("10-19","20-29","0-9g/day","30+")))
esoph[ord, ]
}
