% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Si.pred.R
\name{Si.pred}
\alias{Si.pred}
\title{Predict Siler model}
\usage{
Si.pred(data, Sout, rm = 0)
}
\arguments{
\item{data}{frame with age clases and frequency of occurrence (see Details).}

\item{Sout}{A model object created with \link{Si.mod} with the 5 Siler's parameters.}

\item{rm}{The number of age classes that want to be removed from optimization (see Details).}
}
\description{
Predict Siler model from Siler's parameters
}
\details{
The data used must be the data frame from which the Siler's patameters were estimated, whose first column is a vector of the estimated ages of the animals found dead and the second the frequency of occurrence of those ages.

In case that any age class had been removed for the estimation of the parameters that are going to be used for predicting the model, indicate it with the parameter "rm" and these age classes will be removed starting from the first age class.
}
\examples{

modSi <- Si.mod(data = cetaceans, rm = 2,
                par = c(0.3159462,  0.1860541, -1.2802880,  1.1733226,  0.0170314))

Si.pred(data = cetaceans, Sout = modSi, rm = 2)

}
\references{
Siler, W. (1979). A Competing-Risk Model for Animal Mortality. Ecology 60, 750–757.

Siler, W. (1983). Parameters of mortality in human populations with widely varying life spans. Stat. Med. 2, 373–380.
}
\seealso{
\link{Si.mod}
}
\keyword{Siler}
\keyword{mortality}
