% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idRows.R
\name{idRows}
\alias{idRows}
\title{\code{gtypes} ID Rows}
\usage{
idRows(g, ids = NULL, as.names = FALSE)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{ids}{character vector of sample ids. If \code{NULL}, returns marix of 
all ids.}

\item{as.names}{\code{FALSE} returns numeric matrix of row numbers. \code{TRUE} 
returns character matrix of rownames.}
}
\value{
a matrix of rownames or row numbers for sample ids in the \code{loci} 
  slot of a gtypes object.
}
\description{
Return lookup matrix of row numbers or row names of 
  \code{@loci} slot for sample ids.
}
\examples{
data(msats.g)

# lookup table of all samples by number
by.num <- idRows(msats.g)
head(by.num)

# lookup table of all samples by name
by.name <- idRows(msats.g, as.name = TRUE)
head(by.name)

# lookup table of selected ids
ran.ids <- sample(indNames(msats.g), 5)
ran.by.num <- idRows(msats.g, ids = ran.ids, as.name = TRUE)
ran.ids

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

