% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variableSites.R
\name{variableSites}
\alias{variableSites}
\title{Variable Sites}
\usage{
variableSites(x, bases = c("a", "c", "g", "t", "-"))
}
\arguments{
\item{x}{a \linkS4class{gtypes} object with sequences, 
a \code{\link[ape]{DNAbin}} object, or a list of sequences.}

\item{bases}{character vector of bases to consider.}
}
\value{
A list with: \describe{
  \item{site}{a \code{\link[ape]{DNAbin}} object composed of variable sites.}
  \item{site.freqs}{a matrix of base pair frequencies by site.}
}
}
\description{
Identify variable sites among sequences.
}
\examples{
data(dolph.haps)

variableSites(dolph.haps)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\seealso{
\code{\link{fixedSites}}
}

