% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackHWE.R
\name{jackHWE}
\alias{jackHWE}
\alias{jackInfluential}
\alias{plot.jack.influential}
\alias{.alleleFreqFormat}
\title{Hardy-Weinberg Equlibrium Jackknife}
\usage{
jackHWE(g, exclude.num = 1, min.hwe.samples = 5, show.progress = TRUE, ...)

jackInfluential(jack.result, alpha = 0.05)

\method{plot}{jack.influential}(x, main = NULL, ...)

.alleleFreqFormat(x, g)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{exclude.num}{Number of samples to exclude at a time.}

\item{min.hwe.samples}{minimum samples needed to calculate HWE.}

\item{show.progress}{logical. Show progress of jackknife?}

\item{...}{other arguments to be passed to \code{\link{hweTest}}.}

\item{jack.result}{result from run of \code{jackHWE}.}

\item{alpha}{critical value to determine if exclusion is "influential".}

\item{x}{a matrix or data.frame where first column is sample id and 
second colum is locus name.}

\item{main}{main title for influential sample plots from 
\code{plot.jack.influential}.}
}
\value{
\code{jackHWE} returns a list with:
\item{obs}{a named vector of HWE p-values for each locus.}
\item{jack}{a \code{data.frame} of HWE p-values where each row is an 
  exclusion and columns are loci.}
\item{gtypes}{the original \code{gtypes} object.}\cr
\code{jackInfluential} returns a list with:
\item{influential}{a \code{data.frame} of influential exclusions.}
\item{allele.freqs}{a \code{data.frame} listing the allele frequencies of 
  influential exclusions.}
\item{odds.ratio}{a \code{matrix} of odds ratios between exclusions (rows) 
  and loci (columns).}
}
\description{
Test influence of samples on Hardy-Weinberg equilibrium via 
  jackknife.
}
\details{
\describe{
  \item{\code{jackHWE}}{performs a HWE jackknife where all combinations 
    of \code{exclude.num} samples are left out and HWE is recalculated}
  \item{\code{jackInfluential}}{calculates odds.ratios between jackknife 
    HWE and observed HWE and identifies "influential" samples. Samples 
    are "influential" if the observed HWE p-value is < \code{alpha}, but 
    is > \code{alpha} when the samples are not present}
  \item{\code{plot.jack.influential}}{creates a cumulative frequency plot 
    of all odds-ratios from \code{jack.influential}. A vertical dashed 
    line marks the smallest influential exclusion}
}
}
\references{
Morin, P.A., R.G. LeDuc, F.I. Archer, K.K. Martien, 
  R. Huebinger, J.W. Bickham, and B.L. Taylor. 2009. Significant deviations 
  from Hardy-Weinberg equilibirum caused by low levels of microsatellite 
  genotyping errors. Molecular Ecology Resources 9:498-504.
}
\seealso{
\code{\link{hweTest}}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\keyword{internal}
