% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{allocation_summary}
\alias{allocation_summary}
\title{Summarizing the Allocation}
\usage{
allocation_summary(x, a, m = NULL, M = NULL)
}
\arguments{
\item{x}{(\code{numeric})\cr the allocation vector.}

\item{a}{(\code{numeric})\cr parameters \eqn{a_1, ..., a_H} of variance function
\eqn{D}. See \code{\link[=dopt]{dopt()}} or \code{\link[=nopt]{nopt()}} for more details.}

\item{m}{(\code{numeric} or \code{NA})\cr lower bounds constraints imposed on sample
sizes in strata.}

\item{M}{(\code{numeric} or \code{NA})\cr upper bounds constraints imposed on sample
sizes in strata.}
}
\value{
A \code{\link{data.frame}} with the allocation summary.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A helper function that creates and returns a simple \code{\link{data.frame}} with
summary of the allocation as returned by the \code{\link[=dopt]{dopt()}} or \code{\link[=nopt]{nopt()}}. See the
illustrate example below.
}
\details{
The summary \code{\link{data.frame}} contains the following columns: \cr
(1) the allocation vector, \cr
(2) lower bounds constraints (optional), \cr
(3) upper bounds constraints (optional), \cr
(4) indication whether the allocation for a given stratum is of \code{take-min}
type, i.e. x == m (optional), \cr
(5) indication whether the allocation for a given stratum is of \code{take-max}
type, i.e. x == M (optional), \cr
(6) indication whether the allocation for a given stratum is of \code{take-neyman}
type, i.e. m < x < M. \cr
The last row contains the sum of all of the values from the other rows
(wherever feasible).
}
\examples{
a <- c(3000, 4000, 5000, 2000)
m <- c(100, 90, 70, 80)
M <- c(200, 150, 300, 210)

x1 <- dopt(n = 400, a, m)
s1 <- allocation_summary(x1, a, m)

x2 <- dopt(n = 540, a, m, M)
s2 <- allocation_summary(x2, a, m, M)
}
