% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DST.R
\name{DST}
\alias{DST}
\alias{description}
\alias{get_model}
\title{Conceptual Base Class for All Data Stream Mining Tasks}
\usage{
DST(...)

description(x, ...)

get_model(x, ...)
}
\arguments{
\item{...}{Further arguments.}

\item{x}{an object of a concrete implementation of a DST.}
}
\description{
Conceptual base class for all data stream mining tasks.
}
\details{
Base class for data stream mining tasks. Types of \code{DST} are
\itemize{
\item \link{DSAggregate} to aggregate data streams (e.g., with a sliding window).
\item \link{DSC} for data stream clustering.
\item \link{DSClassifier} classification for data streams.
\item \link{DSRegressor} regression for data streams.
\item \link{DSOutlier} outlier detection for data streams.
\item \link{DSFP} frequent pattern mining for data streams.
}

The common interface for all \link{DST} classes consists of
\itemize{
\item \code{\link[=update]{update()}} update the DST with data points.
\item description() a string describing the DST.
\item get_model() returns the DST's current model (often as a data.frame or a R model object).
\item \code{\link[=predict]{predict()}} use the learned DST model to make predictions.
}

and the methods in the Methods Section below.
}
\examples{
DST()
}
\seealso{
Other DST: 
\code{\link{DSAggregate}()},
\code{\link{DSClassifier}()},
\code{\link{DSC}()},
\code{\link{DSOutlier}()},
\code{\link{DSRegressor}()},
\code{\link{DST_SlidingWindow}()},
\code{\link{DST_WriteStream}()},
\code{\link{evaluate}},
\code{\link{predict}()},
\code{\link{stream_pipeline}},
\code{\link{update}()}
}
\author{
Michael Hahsler
}
\concept{DST}
