/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.driftdetection;

import moa.classifiers.core.driftdetection.AbstractChangeDetector;
import moa.core.ObjectRepository;
import moa.options.IntOption;
import moa.tasks.TaskMonitor;

public class DDM
extends AbstractChangeDetector {
    private static final long serialVersionUID = -3518369648142099719L;
    public IntOption minNumInstancesOption = new IntOption("minNumInstances", 'n', "The minimum number of instances before permitting detecting change.", 30, 0, Integer.MAX_VALUE);
    private int m_n;
    private double m_p;
    private double m_s;
    private double m_psmin;
    private double m_pmin;
    private double m_smin;

    public DDM() {
        this.resetLearning();
    }

    public void resetLearning() {
        this.m_n = 1;
        this.m_p = 1.0;
        this.m_s = 0.0;
        this.m_psmin = Double.MAX_VALUE;
        this.m_pmin = Double.MAX_VALUE;
        this.m_smin = Double.MAX_VALUE;
    }

    public void input(double prediction) {
        if (this.isChangeDetected) {
            this.resetLearning();
        }
        this.m_p += (prediction - this.m_p) / (double)this.m_n;
        this.m_s = Math.sqrt(this.m_p * (1.0 - this.m_p) / (double)this.m_n);
        ++this.m_n;
        this.estimation = this.m_p;
        this.isChangeDetected = false;
        this.isWarningZone = false;
        this.delay = 0.0;
        if (this.m_n < this.minNumInstancesOption.getValue()) {
            return;
        }
        if (this.m_p + this.m_s <= this.m_psmin) {
            this.m_pmin = this.m_p;
            this.m_smin = this.m_s;
            this.m_psmin = this.m_p + this.m_s;
        }
        if (this.m_n > this.minNumInstancesOption.getValue() && this.m_p + this.m_s > this.m_pmin + 3.0 * this.m_smin) {
            this.isChangeDetected = true;
        } else {
            this.isWarningZone = this.m_p + this.m_s > this.m_pmin + 2.0 * this.m_smin;
        }
    }

    public void getDescription(StringBuilder sb, int indent) {
    }

    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }
}

