/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.multilabel.instancetransformers;

import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstanceImpl;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import com.yahoo.labs.samoa.instances.Range;
import java.util.ArrayList;
import moa.classifiers.rules.multilabel.instancetransformers.InstanceOutputAttributesSelector;
import moa.classifiers.rules.multilabel.instancetransformers.InstanceTransformer;

public class InstanceAttributesSelector
extends InstanceOutputAttributesSelector
implements InstanceTransformer {
    private static final long serialVersionUID = 1L;
    public InstancesHeader targetInstances;
    public int[] targetInputIndices;
    public int[] targetOutputIndices;
    public int numSourceInstancesOutputs;

    public InstanceAttributesSelector(InstancesHeader sourceInstances, int[] targetInputIndices, int[] targetOutputIndices) {
        int i;
        this.targetInputIndices = targetInputIndices;
        this.targetOutputIndices = targetOutputIndices;
        this.numSourceInstancesOutputs = sourceInstances.numOutputAttributes();
        int totAttributes = this.targetInputIndices.length + this.targetOutputIndices.length;
        this.targetInstances = new InstancesHeader();
        ArrayList<Attribute> v = new ArrayList<Attribute>(totAttributes);
        ArrayList<Integer> indexValues = new ArrayList<Integer>(totAttributes);
        int ct = 0;
        for (i = 0; i < this.targetInputIndices.length; ++i) {
            v.add(sourceInstances.inputAttribute(this.targetInputIndices[i]));
            indexValues.add(ct);
            ++ct;
        }
        for (i = 0; i < this.targetOutputIndices.length; ++i) {
            v.add(sourceInstances.outputAttribute(this.targetOutputIndices[i]));
            indexValues.add(ct);
            ++ct;
        }
        this.targetInstances.setAttributes(v, indexValues);
        Range r = new Range("-" + targetOutputIndices.length);
        r.setUpper(totAttributes);
        this.targetInstances.setRangeOutputIndices(r);
    }

    @Override
    public Instance sourceInstanceToTarget(Instance sourceInstance) {
        int i;
        double[] attValues = new double[this.targetInstances.numAttributes()];
        InstanceImpl newInstance = new InstanceImpl(sourceInstance.weight(), attValues);
        for (i = 0; i < this.targetInputIndices.length; ++i) {
            newInstance.setValue(i, sourceInstance.valueInputAttribute(this.targetInputIndices[i]));
        }
        for (i = 0; i < this.targetOutputIndices.length; ++i) {
            newInstance.setValue(i, sourceInstance.valueOutputAttribute(this.targetOutputIndices[i]));
        }
        newInstance.setDataset(this.targetInstances);
        return newInstance;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

