/*
 * Decompiled with CFR 0.152.
 */
package moa.core;

import java.io.Serializable;
import java.util.ArrayList;
import moa.AbstractMOAObject;

public class GreenwaldKhannaQuantileSummary
extends AbstractMOAObject {
    private static final long serialVersionUID = 1L;
    protected Tuple[] summary;
    protected int numTuples = 0;
    protected long numObservations = 0L;

    public GreenwaldKhannaQuantileSummary(int maxTuples) {
        this.summary = new Tuple[maxTuples];
    }

    public void insert(double val) {
        int i = this.findIndexOfTupleGreaterThan(val);
        Tuple nextT = this.summary[i];
        if (nextT == null) {
            this.insertTuple(new Tuple(val, 1L, 0L), i);
        } else {
            this.insertTuple(new Tuple(val, 1L, nextT.g + nextT.delta - 1L), i);
        }
        if (this.numTuples == this.summary.length) {
            this.deleteMergeableTupleMostFull();
        }
        ++this.numObservations;
    }

    protected void insertTuple(Tuple t, int index) {
        System.arraycopy(this.summary, index, this.summary, index + 1, this.numTuples - index);
        this.summary[index] = t;
        ++this.numTuples;
    }

    protected void deleteTuple(int index) {
        this.summary[index] = new Tuple(this.summary[index + 1].v, this.summary[index].g + this.summary[index + 1].g, this.summary[index + 1].delta);
        System.arraycopy(this.summary, index + 2, this.summary, index + 1, this.numTuples - index - 2);
        this.summary[this.numTuples - 1] = null;
        --this.numTuples;
    }

    protected void deleteTupleMostFull() {
        long leastFullness = Long.MAX_VALUE;
        int leastFullIndex = 0;
        for (int i = 1; i < this.numTuples - 1; ++i) {
            long fullness = this.summary[i].g + this.summary[i + 1].g + this.summary[i + 1].delta;
            if (fullness >= leastFullness) continue;
            leastFullness = fullness;
            leastFullIndex = i;
        }
        if (leastFullIndex > 0) {
            this.deleteTuple(leastFullIndex);
        }
    }

    protected void deleteMergeableTupleMostFull() {
        long leastFullness = Long.MAX_VALUE;
        int leastFullIndex = 0;
        for (int i = 1; i < this.numTuples - 1; ++i) {
            long fullness = this.summary[i].g + this.summary[i + 1].g + this.summary[i + 1].delta;
            if (this.summary[i].delta < this.summary[i + 1].delta || fullness >= leastFullness) continue;
            leastFullness = fullness;
            leastFullIndex = i;
        }
        if (leastFullIndex > 0) {
            this.deleteTuple(leastFullIndex);
        }
    }

    public long getWorstError() {
        long mostFullness = 0L;
        for (int i = 1; i < this.numTuples - 1; ++i) {
            long fullness = this.summary[i].g + this.summary[i].delta;
            if (fullness <= mostFullness) continue;
            mostFullness = fullness;
        }
        return mostFullness;
    }

    public long findMaxDelta() {
        long maxDelta = 0L;
        for (int i = 0; i < this.numTuples; ++i) {
            if (this.summary[i].delta <= maxDelta) continue;
            maxDelta = this.summary[i].delta;
        }
        return maxDelta;
    }

    public void compress(long maxDelta) {
        long[] bandBoundaries = GreenwaldKhannaQuantileSummary.computeBandBoundaries(maxDelta);
        for (int i = this.numTuples - 2; i >= 0; --i) {
            int childI;
            if (this.summary[i].delta < this.summary[i + 1].delta) continue;
            int band = 0;
            while (this.summary[i].delta < bandBoundaries[band]) {
                ++band;
            }
            long belowBandThreshold = Long.MAX_VALUE;
            if (band > 0) {
                belowBandThreshold = bandBoundaries[band - 1];
            }
            long mergeG = this.summary[i + 1].g + this.summary[i].g;
            for (childI = i - 1; mergeG + this.summary[i + 1].delta < maxDelta && childI >= 0 && this.summary[childI].delta >= belowBandThreshold; --childI) {
                mergeG += this.summary[childI].g;
            }
            if (mergeG + this.summary[i + 1].delta >= maxDelta) continue;
            int numDeleted = i - childI;
            this.summary[childI + 1] = new Tuple(this.summary[i + 1].v, mergeG, this.summary[i + 1].delta);
            System.arraycopy(this.summary, i + 2, this.summary, childI + 2, this.numTuples - (i + 2));
            for (int j = this.numTuples - numDeleted; j < this.numTuples; ++j) {
                this.summary[j] = null;
            }
            this.numTuples -= numDeleted;
            i = childI + 1;
        }
    }

    public double getQuantile(double quant) {
        long r = (long)Math.ceil(quant * (double)this.numObservations);
        long currRank = 0L;
        for (int i = 0; i < this.numTuples - 1; ++i) {
            if ((currRank += this.summary[i].g) + this.summary[i + 1].g <= r) continue;
            return this.summary[i].v;
        }
        return this.summary[this.numTuples - 1].v;
    }

    public long getTotalCount() {
        return this.numObservations;
    }

    public double getPropotionBelow(double cutpoint) {
        return (double)this.getCountBelow(cutpoint) / (double)this.numObservations;
    }

    public long getCountBelow(double cutpoint) {
        long rank = 0L;
        for (int i = 0; i < this.numTuples && !(this.summary[i].v > cutpoint); ++i) {
            rank += this.summary[i].g;
        }
        return rank;
    }

    public double[] getSuggestedCutpoints() {
        double[] cutpoints = new double[this.numTuples];
        for (int i = 0; i < this.numTuples; ++i) {
            cutpoints[i] = this.summary[i].v;
        }
        return cutpoints;
    }

    protected int findIndexOfTupleGreaterThan(double val) {
        int high = this.numTuples;
        int low = -1;
        while (high - low > 1) {
            int probe = (high + low) / 2;
            if (this.summary[probe].v > val) {
                high = probe;
                continue;
            }
            low = probe;
        }
        return high;
    }

    public static long[] computeBandBoundaries(long maxDelta) {
        long boundary;
        ArrayList<Long> boundaryList = new ArrayList<Long>();
        boundaryList.add(new Long(maxDelta));
        int alpha = 1;
        while ((boundary = maxDelta - (long)(2 << alpha - 1) - maxDelta % (long)(2 << alpha - 1)) >= 0L) {
            boundaryList.add(new Long(boundary + 1L));
            ++alpha;
        }
        boundaryList.add(new Long(0L));
        long[] boundaries = new long[boundaryList.size()];
        for (int i = 0; i < boundaries.length; ++i) {
            boundaries[i] = (Long)boundaryList.get(i);
        }
        return boundaries;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    protected static class Tuple
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double v;
        public long g;
        public long delta;

        public Tuple(double v, long g, long delta) {
            this.v = v;
            this.g = g;
            this.delta = delta;
        }

        public Tuple(double v) {
            this(v, 1L, 0L);
        }
    }
}

