/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.visualization;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.text.DecimalFormat;
import javax.swing.GroupLayout;
import javax.swing.JPanel;

public abstract class AbstractGraphAxes
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final int X_OFFSET_LEFT = 35;
    protected static final int X_OFFSET_RIGHT = 15;
    protected static final int Y_OFFSET_BOTTOM = 20;
    protected static final int Y_OFFSET_TOP = 20;
    protected int width;
    protected int height;
    protected double x_resolution;
    protected double y_resolution;
    protected double min_x_value = 0.0;
    protected double max_x_value = 1.0;
    protected double max_y_value = 1.0;
    protected double lower_x_value = 0.0;
    protected double upper_x_value = 1.0;
    protected double upper_y_value = 1.0;

    public AbstractGraphAxes() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void setXResolution(double resolution) {
        this.x_resolution = resolution;
    }

    public void setYResolution(double resolution) {
        this.y_resolution = resolution;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.height = this.getHeight() - 20 - 20;
        this.width = this.getWidth() - 35 - 15;
        g.setColor(new Color(236, 233, 216));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.WHITE);
        g.fillRect(35, 20, this.width, this.height);
        g.setFont(new Font("Tahoma", 0, 11));
        this.xAxis(g);
        this.yAxis(g);
    }

    protected void xAxis(Graphics g) {
        g.setColor(Color.BLACK);
        g.drawLine(35, this.calcY(0.0), this.width + 35, this.calcY(0.0));
        this.drawXLabels(g);
    }

    protected abstract void drawXLabels(Graphics var1);

    private void yAxis(Graphics g) {
        g.setColor(Color.BLACK);
        g.drawLine(35, this.calcY(0.0), 35, 20);
        g.setColor(new Color(220, 220, 220));
        g.drawLine(35, this.height / 2 + 20, this.getWidth(), this.height / 2 + 20);
        g.setColor(Color.BLACK);
        DecimalFormat d = new DecimalFormat("0.00");
        double numLabels = Math.min(Math.pow(2.0, this.y_resolution), 32.0);
        int i = 0;
        while ((double)i <= numLabels) {
            double fraction = (double)i / numLabels;
            double value = fraction * this.upper_y_value;
            g.drawString(d.format(value), 1, (int)((1.0 - fraction) * (double)this.height) + 20 + 5);
            g.drawLine(30, (int)((1.0 - fraction) * (double)this.height) + 20, 35, (int)((1.0 - fraction) * (double)this.height) + 20);
            ++i;
        }
    }

    public void setMinXValue(double min) {
        this.min_x_value = min;
    }

    public void setMaxXValue(double max) {
        this.max_x_value = max;
    }

    public void setMaxYValue(double max) {
        this.max_y_value = max;
    }

    public void setLowerXValue(double value) {
        this.lower_x_value = value;
    }

    public void setUpperXValue(double value) {
        this.upper_x_value = value;
    }

    public void setUpperYValue(double value) {
        this.upper_y_value = value;
    }

    private int calcY(double value) {
        return (int)((double)this.height - value / this.max_y_value * (double)this.height) + 20;
    }
}

