% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streambugs_plot.r
\name{foodweb.plot}
\alias{foodweb.plot}
\title{Plot the streambugs "foodweb" graph.}
\usage{
foodweb.plot(y.names, par, file = NA, cex = 1, font = 1,
  title = "", lwd = 1, bg = colors()[1], lcol = colors()[555],
  ncrit = 8, lcrit = 20, survivals = NA, observed = NA,
  texts = TRUE, pointcol = FALSE, ...)
}
\arguments{
\item{y.names}{same as \code{y.names} in \code{\link{run.streambugs}}}

\item{par}{same as \code{par} in \code{\link{run.streambugs}}}

\item{file}{optional name of a PDF file to plot to}

\item{cex}{same as \code{cex} in \code{\link[graphics]{par}}, consumed by here by
multiple text generating functions}

\item{font}{same as \code{font} in \code{\link[graphics]{par}}, consumed here by
\code{\link[graphics]{text}} as a font type for taxa names}

\item{title}{optional title for the plot}

\item{lwd}{same as \code{lwd} in \code{\link[graphics]{par}}, consumed here by
\code{\link[graphics]{lines}} as a line width for the "food web" edges}

\item{bg}{same as \code{bg} in \code{\link[graphics]{par}}}

\item{lcol}{same as \code{col} in \code{\link[graphics]{par}}, consumed here by
\code{\link[graphics]{lines}} as a line color for the "food web" edges}

\item{ncrit}{number of inverts in one line at which they are shifted up and down,
alternating}

\item{lcrit}{number of letters/characters of state names which are plottet at level 2}

\item{survivals}{vector with the entries \code{"survived"} or \code{"extinct"} for
all state variables with names matching names of taxa state variables and
\code{"SusPOM"}}

\item{observed}{vector with the entries \code{"never"}/\code{"notobserved"},
\code{"observed"},\code{"sometimes"}, \code{"always"}, or \code{NA}/\code{"NA"}
for all state variables, with names matching names of taxa state variables and
\code{"SusPOM"}}

\item{texts}{if to plot as "food web"nodes as texts with taxa names; otherwise, plot
points}

\item{pointcol}{if to color text or point nodes using Eawag coloring scheme
(eawagfarben); otherwise plot all in the same color}

\item{...}{additional arguments for the \code{\link[grDevices]{pdf}} graphics device,
relevant only if \code{file} argument was given.}
}
\description{
Plot the "foodweb" graph depicting interactions between ODE variables in a streambugs
model.
}
\examples{
model <- streambugs.example.model.toy()
foodweb.plot(model$y.names, model$par, cex=1.1, title="complete foodweb", ncrit=8,
    lcrit=7, lwd=2, bg="white", lcol="blue", font=2)

}
