% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elem.R
\name{str_elem}
\alias{str_elem}
\title{Extract a single character from a string, using its index.}
\usage{
str_elem(string, index)
}
\arguments{
\item{string}{A character vector.}

\item{index}{An integer. Negative indexing is allowed as in
\code{\link[stringr:str_sub]{stringr::str_sub()}}.}
}
\value{
A one-character string.
}
\description{
If the element does not exist, this function returns the empty string. This
is consistent with \code{\link[stringr:str_sub]{stringr::str_sub()}}. This function is vectorised over
both arguments.
}
\examples{
str_elem(c("abcd", "xyz"), 3)
str_elem("abcd", -2)
}
\seealso{
Other single element extractors: \code{\link{str_elems}},
  \code{\link{str_paste_elems}}
}
\concept{single element extractors}
