% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.r
\name{str_extract}
\alias{str_extract}
\alias{str_extract_all}
\title{Extract matching patterns from a string.}
\usage{
str_extract(string, pattern)

str_extract_all(string, pattern, simplify = FALSE)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern}{Pattern to look for.

  The default interpretation is a regular expression, as described
  in \link[stringi]{stringi-search-regex}. Control options with
  \code{\link{regex}()}.

  Match a fixed string (i.e. by comparing only bytes), using
  \code{\link{fixed}(x)}. This is fast, but approximate. Generally,
  for matching human text, you'll want \code{\link{coll}(x)} which
  respects character matching rules for the specified locale.

  Match character, word, line and sentence boundaries with
  \code{\link{boundary}()}. An empty pattern, "", is equivalent to
  \code{boundary("character")}.}

\item{simplify}{If \code{FALSE}, the default, returns a list of character
vectors. If \code{TRUE} returns a character matrix.}
}
\value{
A character vector.
}
\description{
Vectorised over \code{string} and \code{pattern}.
}
\examples{
shopping_list <- c("apples x4", "bag of flour", "bag of sugar", "milk x2")
str_extract(shopping_list, "\\\\d")
str_extract(shopping_list, "[a-z]+")
str_extract(shopping_list, "[a-z]{1,4}")
str_extract(shopping_list, "\\\\b[a-z]{1,4}\\\\b")

# Extract all matches
str_extract_all(shopping_list, "[a-z]+")
str_extract_all(shopping_list, "\\\\b[a-z]+\\\\b")
str_extract_all(shopping_list, "\\\\d")

# Simplify results into character matrix
str_extract_all(shopping_list, "\\\\b[a-z]+\\\\b", simplify = TRUE)
str_extract_all(shopping_list, "\\\\d", simplify = TRUE)

# Extract all words
str_extract_all("This is, suprisingly, a sentence.", boundary("word"))
}
\seealso{
\code{\link{str_match}} to extract matched groups;
  \code{\link[stringi]{stri_extract}} for the underlying implementation.
}

