% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrambleAlleles.r
\name{scrambleAlleles}
\alias{scrambleAlleles}
\title{Scramble Alleles}
\usage{
scrambleAlleles(data, db = "ESX 17 Hill")
}
\arguments{
\item{data}{data.frame with columns 'Sample.Name', 'Marker', and 'Allele'.}

\item{db}{character defining the allele frequecy database to be used.}
}
\value{
data.frame with changes in 'Allele' column.
}
\description{
Scrambles alleles in a dataset to anonymise the profile.
}
\details{
Internal helper function to create example data.
Assumes data with unique alleles per marker i.e. no duplications.
This allow for sampling without replacement see \code{\link{sample}}.
Sex markers are currently not scrambled i.e. they are kept intact.
Alleles in the dataset is replaced with random alleles sampled from the allele database.
If 'Size' is in the dataset it will be replaced by an estimated size.
If 'Data.Point' is present it will be removed.
}
