% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossvalidate.R
\name{crossvalidate}
\alias{crossvalidate}
\title{Cross-Validate a Measurement Model}
\usage{
crossvalidate(selection, old.data, new.data, invariance = "configural",
  objective = NULL, filename = NULL)
}
\arguments{
\item{selection}{An object of class \code{stuartOutput}.}

\item{old.data}{A \code{data.frame} of the calibration sample.}

\item{new.data}{A \code{data.frame} of the validation sample.}

\item{invariance}{The invariance between the calibration and the validation sample. Can be one of 'configural', 'weak', 'strong', 'strict', or 'full', with the first being the default. Currently 'full' is only functional when using Mplus.}

\item{objective}{A function that converts the results of model estimation into a pheromone. If none is provided the default function \code{fitness} is used. This can be examined with \code{body(stuart:::fitness)}.}

\item{filename}{The stem of the filenames used to save inputs, outputs, and data files when \code{software='Mplus'}. This may include the file path. When \code{NULL} (the default) files will be saved to the temporary directory, which is deleted when the R session is ended.}
}
\value{
Returns a list containing the \code{data.frame} \code{comparison} and an object containing the model results of the validation sample. 

\item{comparison}{A \code{data.frame} with 2 observations. The first observation shows the components of the objective function for the final model in the calibration sample. The second observation those of the model for the validation sample. Which variables are returned depends on the setting of \code{objective}.}
\item{validation}{When using \code{lavaan} for estimation, an object of class \code{lavaan} containing the model results fit to the validation sample. When using Mplus for estimation, a character vector containing the Mplus output for the validation sample.}
}
\description{
Cross-validate a measurement model obtained from STUART.
}
\examples{

# Split data into two halves
data(fairplayer)
half1 <- fairplayer[1:72,]
half2 <- fairplayer[73:143,]

# Simple example from bruteforce
fs <- list(ra = names(fairplayer)[53:57])
sel <- bruteforce(half1, fs, 3,
  cores = 1)  # number of cores set to 1

# Validation
crossvalidate(sel, half1, half2, 
  invariance = 'strong')  # assuming equality of loadings and intercepts

# Using the 'holdout' function for data split
data(fairplayer)
split <- holdout(fairplayer, seed = 55635)

# Simple example from bruteforce
fs <- list(ra = names(fairplayer)[53:57])
sel <- bruteforce(split, fs, 3,
  cores = 1)  # number of cores set to 1

# Validation
crossvalidate(sel, split,
  invariance = 'weak')  # assuming equality of loadings

}
\seealso{
\code{\link{holdout}}, \code{\link{mmas}}, \code{\link{bruteforce}}
}
\author{
Martin Schultze
}
\concept{
ACO subtests
}
