% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinations.R
\name{combinations}
\alias{combinations}
\title{Compute the number of possible subtest combinations}
\usage{
combinations(
  data,
  factor.structure,
  capacity = NULL,
  repeated.measures = NULL,
  mtmm = NULL,
  use.order = FALSE,
  ...
)
}
\arguments{
\item{data}{A data.frame containing all relevant data.}

\item{factor.structure}{A list linking factors to items. The names of the list elements correspond to the factor names. Each list element must contain a character-vector of item names that are indicators of this factor.}

\item{capacity}{A list containing the number of items per subtest. This must be in the same order as the \code{factor.structure} provided. If a single number, it is applied to all subtests. If \code{NULL} all items are evenly distributed among the subtests.}

\item{repeated.measures}{A list linking factors that are repeated measures of each other. Repeated factors must be in one element of the list - other sets of factors in other elements of the list. When this is \code{NULL} (the default) a cross-sectional model is estimated.}

\item{mtmm}{A list linking factors that are measurements of the same construct with different methods. Measurements of the same construct must be in one element of the list - other sets of methods in other elements of the list. When this is \code{NULL} (the default) a single method model is estimated.}

\item{use.order}{A logical indicating whether or not to take the selection order of the items into account. Defaults to \code{FALSE}.}

\item{...}{Other arguments normally provided to \code{\link{mmas}}, which will be ignored.}
}
\value{
Returns the number of possible subtest constellations.
}
\description{
Used to compute the number of possible subtest constellations prior to performing item selection.
}
\examples{

# Determine number of combinations in a simple situation
data(fairplayer)
fs <- list(si = names(fairplayer)[83:92])
combinations(fairplayer, fs, 4)

# Number of combinations with repeated measures
data(fairplayer)
fs <- list(si1 = names(fairplayer)[83:92],
  si2 = names(fairplayer)[93:102],
  si3 = names(fairplayer)[103:112])
repe <- list(si = c('si1', 'si2', 'si3'))
combinations(fairplayer, fs, 4, repeated.measures = repe)

}
\seealso{
\code{\link{bruteforce}}, \code{\link{mmas}}, \code{\link{gene}}
}
\author{
Martin Schultze
}
\concept{ACO subtests}
