% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{style_file}
\alias{style_file}
\title{Style \code{.R} and/or \code{.Rmd} files}
\usage{
style_file(path, ..., style = tidyverse_style, transformers = style(...))
}
\arguments{
\item{path}{A character vector with paths to files to style.}

\item{...}{Arguments passed on to the \code{style} function.}

\item{style}{A function that creates a style guide to use, by default
\code{\link[=tidyverse_style]{tidyverse_style()}} (without the parentheses). Not used
further except to construct the argument \code{transformers}. See
\code{\link[=style_guides]{style_guides()}} for details.}

\item{transformers}{A set of transformer functions. This argument is most
conveniently constructed via the \code{style} argument and \code{...}. See
'Examples'.}
}
\description{
Performs various substitutions in the files specified.
Carefully examine the results after running this function!
}
\section{Value}{

Invisibly returns a data frame that indicates for each file considered for
styling whether or not it was actually changed.
}

\section{Warning}{

This function overwrites files (if styling results in a change of the
code to be formatted). It is strongly suggested to only style files
that are under version control or to create a backup copy.
}

\examples{
# the following is identical but the former is more convenient:
file <- tempfile("styler", fileext = ".R")
enc::write_lines_enc("1++1", file)
style_file(file, style = tidyverse_style, strict = TRUE)
style_file(file, transformers = tidyverse_style(strict = TRUE))
enc::read_lines_enc(file)
unlink(file)
}
\seealso{
Other stylers: \code{\link{style_dir}},
  \code{\link{style_pkg}}, \code{\link{style_text}},
  \code{\link{styler_addins}}
}
