% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform-files.R
\name{apply_transformers}
\alias{apply_transformers}
\title{Apply transformers to a parse table}
\usage{
apply_transformers(pd_nested, transformers)
}
\arguments{
\item{pd_nested}{A nested parse table.}

\item{transformers}{A list of \emph{named} transformer functions}
}
\description{
The column \code{multi_line} is updated (after the line break information is
modified) and the rest of the transformers are applied afterwards,
The former requires two pre visits and one post visit.
}
\details{
The order of the transformations is:
\itemize{
\item Initialization (must be first).
\item Line breaks (must be before spacing due to indention).
\item Update of newline and multi-line attributes (must not change afterwards,
hence line breaks must be modified first).
\item spacing rules (must be after line-breaks and updating newlines and
multi-line).
\item indention.
\item token manipulation / replacement (is last since adding and removing tokens
will invalidate columns token_after and token_before).
\item Update indention reference (must be after line breaks).
}
}
\keyword{internal}
