% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-navigate-nest.R
\name{next_terminal}
\alias{next_terminal}
\title{Tell me what the next terminal is}
\usage{
next_terminal(pd, stack = FALSE, vars = c("pos_id", "token", "text"),
  tokens_exclude = c())
}
\arguments{
\item{pd}{A nest.}

\item{stack}{Whether or not to also return information on the tokens that
are between \code{pd} and the first terminal, so the returned tibble can be
understood as a transition path from \code{pd} to the next terminal, instead of
the information at the terminal only. The order is inside-out,
i.e. the first non-terminal on top, the terminal last.}

\item{vars}{The variables to return.}

\item{tokens_exclude}{A vector with tokens to exclude. This can be helpful if
one wants to find the next token that is not a comment for example.}
}
\value{
Returns a tibble (which is \strong{not} a valid parse table for
\code{stack = TRUE}), with \code{vars} and another variable \code{position} that denotes
the index each element in the transition. This can be helpful in conjunction
with \code{\link[purrr:pluck]{purrr::pluck()}} or \code{\link[purrr:modify_in]{purrr::modify_in()}} to reach the terminal in the
nested structure.
}
\description{
If the first is a terminal, return it. If not, go inside it and search the
next terminal
}
\examples{
pd <- styler:::compute_parse_data_nested("if (TRUE) f()")
styler:::next_terminal(pd)
}
\keyword{internal}
