% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{parse_safely}
\alias{parse_safely}
\title{Save parsing from text}
\usage{
parse_safely(text, ...)
}
\arguments{
\item{text}{Text to parse.}

\item{...}{Parameters passed to \code{\link[base:parse]{base::parse()}}}
}
\description{
Parses text safely, i.e. throws an informative error if EOL style does not
match LF or indicates the exact position where the parsing failed. Note
that we can only detect wrong EOL style if it occurs on the first line
already.
}
\examples{
\dontrun{
styler:::parse_safely("a + 3 -4 -> x\\r\\n glück + 1")
# This cannot be detected as a EOL style problem because the first
# line ends as expected with \\n
styler:::parse_safely("a + 3 -4 -> x\\nx + 2\\r\\n glück + 1")
}
styler:::parse_safely("a + 3 -4 -> \\n glück + 1")
}
\keyword{internal}
