% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stylest_predict.R
\name{stylest_predict}
\alias{stylest_predict}
\title{Predict the most likely speaker of a text}
\usage{
stylest_predict(model, text, prior = NULL)
}
\arguments{
\item{model}{\code{stylest_model} object}

\item{text}{Text vector. May be a \code{corpus_frame} object}

\item{prior}{Prior probability, defaults to \code{NULL}}
}
\value{
\code{stylest_predict} object containing:
\code{model} the fitted \code{stylest_model} object used in prediction,
\code{predicted} the predicted speaker,
\code{log_probs} matrix of log probabilities,
\code{log_prior} matrix of log prior probabilities
}
\description{
Use a fitted stylest_model to predict the most likely speaker of a text.
This function may be used on in-sample or out-of-sample texts.
}
\examples{
data(novels_excerpts)
speaker_mod <- stylest_fit(novels_excerpts$text, novels_excerpts$author)
stylest_predict(speaker_mod, "This is an example text, who wrote it?")
  
}
