% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stylest_fit.R
\name{fit_term_usage}
\alias{fit_term_usage}
\title{Computes speakers' term usage rates}
\usage{
fit_term_usage(
  x,
  speaker,
  terms,
  smooth,
  term_weights,
  fill_method,
  fill_weight,
  weight_varname
)
}
\arguments{
\item{x}{Text vector. May be a \code{corpus_frame} object}

\item{speaker}{Vector of speaker labels. Should be the same length as
\code{x}}

\item{terms}{Vocabulary for document term matrix}

\item{smooth}{Numeric value used smooth term frequencies}

\item{term_weights}{Dataframe of distances (or any weights) per
word in the vocab. This dataframe should have one column $word and
a second column $weight_var containing the weight for the word}

\item{fill_method}{if \code{"value"} (default), \code{fill_weight} is
used to fill any terms with \code{NA} weight. If \code{"mean"}, the
mean term_weight should be used as the fill value}

\item{fill_weight}{numeric value to fill in as weight for any term
which does not have a weight specified in \code{term_weights}}

\item{weight_varname}{Name of the column in term_weights containing the weights}
}
\value{
named list of: terms, vector of num tokens uttered by each speaker,
  smoothing value, term weights (NULL if no weights), terms whose 
  weights were imputed (NULL if no \code{term_weights=NULL}), fill_weight 
  used to fill missing weights (NULL if no \code{term_weights=NULL}),
  and (smoothed) term usage rate matrix
}
\description{
Computes speakers' term usage rates
}
