% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prim.R
\name{prim.cover}
\alias{prim.cover}
\title{PRIM covering strategy}
\usage{
prim.cover(formula, data, X, y, peeling.quantile = 0.03, min.support = 0.05,
  max.peel = 0.1, train.fraction = 0.66, max.boxes = NA,
  quality.function = base::mean, plot = FALSE, minimize = FALSE,
  optimal.box = c("best", "2se"))
}
\arguments{
\item{formula}{Formula with a response and terms}

\item{data}{Data frame to find rules in}

\item{X}{Optionally instead of using a formula: Data frame to find rules in}

\item{y}{Optionally instead of using a formula: Response vector, usually of type numeric}

\item{peeling.quantile}{Quantile to peel off for numerical variables}

\item{min.support}{Minimal size of a box to be valid}

\item{max.peel}{Maximal size of a peel, as a fraction. Defaults to 0.1}

\item{train.fraction}{Train-test split fraction used in validation, defaults to 0.66}

\item{max.boxes}{Maximum number of boxes, NA or leave out for no limit}

\item{quality.function}{Function to use for determining set quality, defaults to mean}

\item{plot}{Plot intermediate results, defaults to false}

\item{minimize}{Should the quality be minimized? Same as setting the quality function to function(x){-quality.function(x)}. Defaults to FALSE}

\item{optimal.box}{During validation, choose the box with the highest quality or a simpler box, two standard errors from the optimum}
}
\value{
An S3 object of class prim.cover
}
\description{
In bump hunting it is customary to follow a so-called covering strategy. This means that the same box construction (rule induction) algorithm is applied sequentially to subsets of the data.
}
\examples{
  data(pima)
  p.cov <- prim.cover(
      class ~ .,
      data = pima,
      peeling.quantile = 0.05,
      min.support = 0.1,
      plot = TRUE,
      optimal.box = "2se"
  )

  \donttest{
  summary(p.cov)
  plot(p.cov)
  }
}
\author{
Jurian Baas
}
