\name{predonfly}
\alias{predonfly}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Probability forecasting
}
\description{
From two sets of observations, first one of complete observations and second one of incomplete observations, provides simulated values of the unknown coordinates.
}
\usage{
predonfly(completeobs,incompleteobs,varnames,subsampsize,nbpreds=1,mixties=FALSE,
          maxtirs=1e5,complete=TRUE,step=NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{completeobs}{
the set of complete observations.
}
  \item{incompleteobs}{
the set of incomplete observations.
}
  \item{varnames}{
the modeled variables.
}
  \item{subsampsize}{
the sub-sample size.
}
  \item{nbpreds}{
the number of predictions for each incomplete observation.
}
  \item{mixties}{
if \code{TRUE}, should put equal weight on tied values, using random permutations (not yet implemented)
}
  \item{maxtirs}{
the maximum number of sub-samples, to stop the computation even if they did not provide \code{nbpreds} predictions for each incomplete observation.
}
  \item{complete}{
If \code{TRUE}, predictions are completed with incomplete observations
}
  \item{step}{
this step defines the neighborhood
}
}
\value{
the matrix of the completed observations
}
\author{
Jerome Collet
}
\examples{
lon=3000
subsampsize=10
dimtot=4
rayon=6
plon=1000

genboules <- function(lon,a,d)
{
  ss <- function(vec)
  {return(sum(vec*vec))}
  surface=matrix(nrow=lon,ncol=d,data=rnorm(lon*d))
  rayons=sqrt(apply(surface,1,ss))
  surface=surface/rayons
  return(matrix(nrow=lon,ncol=d,data=rnorm(lon*d))+a*surface)
}

##############

donori=genboules(lon,rayon,dimtot)
donori=as.data.frame(donori)

dimconnues=3:dimtot
valconnues=matrix(nrow=1,ncol=length(dimconnues),data=0)
valconnues=as.data.frame(valconnues)
names(valconnues)=names(donori)[3:dimtot]
prev <- predonfly(donori,valconnues,names(donori),subsampsize,plon,maxtirs=1e7,step=c(1,2))

boule2=genboules(plon,rayon,2)

plot(boule2[,1:2],xlab='X1',ylab='X2',pch=20,cex=.5)
plot(prev$V1,prev$V2,xlab='X1',ylab='X2',pch=20,cex=.5)
}
